% Nise, N.S. 
% Control Systems Engineering, 7th ed. 
% John Wiley & Sons, Hoboken, NJ, 07030
%
% Control Systems Engineering Toolbox Version 7.0 
% Copyright  2015 by John Wiley & Sons, Inc.
%
% (ch10p2) Example 10.5: We can use MATLAB to make Nyquist diagrams using 
% nyquist(G), where G(s) = numg/deng and G is an LTI transfer-function object. 
% Information about the plots obtained with nyquist(G) can be found by 
% left-clicking the mouse on the curve. You can find the curve's label, as well 
% as the coordinates of the point on which you clicked and the frequency. Right 
% clicking away from a curve brings up a menu if the icons on the menu bar are 
% deselected. From this menu you can select (1) system responses to be 
% displayed and (2) characteristics, such as peak response. 
% When selected, a dot appears on the curve at the appropriate point. Let 
% your mouse rest on the point to read the value of the characteristic. You
% also may  select (3) whether or not to show negative frequencies, (4) choices 
% for grid on or off, and (5) choice for zooming to (-1,0), (6) returning to 
% full view after zooming, and (7) properties, such as labels, limits, units, 
% style, and characteristics. We can obtain points on the plot by using 
% [re,im,w] = nyquist(G), where the real part, imaginary part, and frequency 
% are stored in re, im, and w, respectively, and re and im are 3-D 
% arrays. We can specify a range of w by using [re,im] = nyquist(G,w). 
% We use re(:,:)', and im(:,:)' to convert the arrays to column vectors. 
% Let us look at Example 10.5 in the text.

'(ch10p2) Example 10.5'             % Display label.
clf                                 % Clear graph.
numg=[1 2];                         % Define numerator of G(s).
deng=[1 0 0];                       % Define denominator of G(s).
'G(s)'                              % Display label.
G=tf(numg,deng)                     % Create and display G(s).
nyquist(G)                          % Make a Nyquist diagram.
grid on                             % Turn on grid for Nyquist diagram.
title('Open-Loop Frequency Response') 
                                    % Add a title to the Nyquist diagram.
w=0:0.5:10;                         % Let 0<w<10 in steps of 0.5.
[re,im]=nyquist(G,w);               % Get Nyquist diagram points for a range
                                    % of w.
points=[re(:,:)',im(:,:)',w']       % List specified range of points in 
                                    % Nyquist diagram.
